/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graph2.RectanglesCollection;

public class MyCurve {
    private final CubicCurve2D.Double curve;
    private final List<Line2D.Double> lines = new ArrayList<Line2D.Double>();
    private final List<Line2D.Double> linesForInters = new ArrayList<Line2D.Double>();
    private Color color = Color.GREEN;
    private double lenght = 0.0;

    public MyCurve(CubicCurve2D.Double curve) {
        this.curve = curve;
        this.addCurve(curve);
        if (this.lenght <= 0.0) {
            throw new IllegalStateException();
        }
        for (Line2D.Double line : this.lines) {
            this.linesForInters.add(this.change(line, curve.getP1(), curve.getP2()));
        }
    }

    private Line2D.Double change(Line2D.Double line, Point2D p1, Point2D p2) {
        if (!line.getP1().equals(p1) && !line.getP2().equals(p2)) {
            return line;
        }
        double dx = line.x2 - line.x1;
        double dy = line.y2 - line.y1;
        p1 = line.getP1().equals(p1) ? new Point2D.Double(line.x1 + dx / 10.0, line.y1 + dy / 10.0) : line.getP1();
        p2 = line.getP2().equals(p2) ? new Point2D.Double(line.x2 - dx / 10.0, line.y2 - dy / 10.0) : line.getP2();
        return new Line2D.Double(p1, p2);
    }

    public final double getLenght() {
        return this.lenght;
    }

    private void addCurve(CubicCurve2D.Double peace) {
        Rectangle2D bounds = peace.getBounds2D();
        double flat = peace.getFlatness();
        if (flat < 10.0) {
            this.lines.add(new Line2D.Double(peace.getP1(), peace.getP2()));
            this.lenght += Math.sqrt(bounds.getWidth() * bounds.getWidth() + bounds.getHeight() * bounds.getHeight());
            return;
        }
        CubicCurve2D.Double left = new CubicCurve2D.Double();
        CubicCurve2D.Double right = new CubicCurve2D.Double();
        peace.subdivide(left, right);
        this.addCurve(left);
        this.addCurve(right);
    }

    public void drawDebug(Graphics2D g2d) {
        for (Line2D line2D : this.linesForInters) {
            g2d.setColor(this.color);
            g2d.draw(line2D);
        }
        g2d.setColor(Color.BLACK);
    }

    public void draw(Graphics2D g2d) {
        g2d.setStroke(new BasicStroke(1.5f));
        g2d.draw(this.curve);
        g2d.setStroke(new BasicStroke());
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public boolean intersects(List<MyCurve> others) {
        for (MyCurve other : others) {
            if (!this.intersects(other)) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(MyCurve other) {
        for (Line2D.Double l1 : this.linesForInters) {
            for (Line2D.Double l2 : other.linesForInters) {
                if (!l1.intersectsLine(l2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersects(RectanglesCollection forbidden) {
        for (Rectangle2D.Double r : forbidden) {
            for (Line2D.Double line : this.lines) {
                if (!r.intersectsLine(line)) continue;
                return true;
            }
        }
        return false;
    }
}

